/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.NumberFormat;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

class Sclipter {
    AudioFormat af;
    AudioFileFormat aff;
    float startTime = 0.0f;
    float timeSpan = 0.0f;
    String outFileName = null;
    byte[] soundData = null;
    byte[] outSoundData = null;

    Sclipter(byte[] sound, AudioFileFormat f, float start, float span) {
        this.setup(sound, f, start, span);
        this.mainWork(0);
    }

    Sclipter(byte[] sound, AudioFileFormat f, String file) {
        Sclipter.writeSoundData(sound, f, file);
    }

    Sclipter(byte[] sound, AudioFileFormat f, float start, float span, String file) {
        this.setup(sound, f, start, span);
        this.outFileName = file;
        this.mainWork(1);
    }

    Sclipter(byte[] sound) {
        this.soundData = sound;
    }

    Sclipter() {
    }

    void setup(byte[] sound, AudioFileFormat f, float start, float span) {
        this.soundData = sound;
        this.startTime = start;
        this.timeSpan = span;
        this.aff = f;
        this.af = this.aff.getFormat();
    }

    void setup(AudioFileFormat f, float start, float span) {
        this.startTime = start;
        this.timeSpan = span;
        this.aff = f;
        this.af = this.aff.getFormat();
    }

    void setSound(byte[] sound) {
        this.soundData = sound;
    }

    void mainWork(int flag) {
        int startPoint = (int)Math.floor((float)this.af.getFrameSize() * this.af.getFrameRate() * this.startTime);
        int duration = (int)Math.floor((float)this.af.getFrameSize() * this.af.getFrameRate() * this.timeSpan);
        int adjuster = this.af.getFrameSize() * 4;
        startPoint += adjuster - startPoint % adjuster;
        duration += adjuster - duration % adjuster;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.soundData, startPoint, duration);
            this.outSoundData = baos.toByteArray();
            System.out.print("Start Time: ");
            System.out.println(Sclipter.convertToSexa(this.startTime));
            System.out.print("Duration: ");
            System.out.println(Sclipter.convertToSexa(this.timeSpan));
            System.out.print("End Time: ");
            System.out.println(Sclipter.convertToSexa(this.startTime + this.timeSpan));
            if (flag != 0 && flag == 1) {
                int n = Sclipter.writeSoundData(this.outSoundData, this.aff, this.outFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Out Soud File Error(Sclipter)");
            System.exit(0);
        }
    }

    AudioFileFormat getFormat() {
        return this.aff;
    }

    static int writeSoundData(byte[] soundData, AudioFileFormat aff, String outFileName) {
        int totalFileSize = 0;
        try {
            File outFile = new File(outFileName);
            AudioFormat af = aff.getFormat();
            ByteArrayInputStream bais = new ByteArrayInputStream(soundData);
            AudioInputStream outAis = new AudioInputStream(bais, af, soundData.length);
            AudioFileFormat.Type affType = aff.getType();
            totalFileSize = AudioSystem.write(outAis, affType, outFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Out File Error(Sclipter)");
            System.exit(0);
        }
        System.out.println("Output File Name : " + outFileName);
        System.out.println("Total output File Size : " + totalFileSize);
        return totalFileSize;
    }

    byte[] getSound() {
        return this.outSoundData;
    }

    static String convertToSexa(float time) {
        int hh = (int)(time / 3600.0f);
        int min = (int)((time - (float)(hh * 60 * 60)) / 60.0f);
        NumberFormat df = NumberFormat.getNumberInstance();
        df.setGroupingUsed(false);
        String sec = df.format(time - (float)(hh * 60 * 60) - (float)(min * 60));
        return String.valueOf(hh) + ":" + min + ":" + sec;
    }
}

