/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

class Sclip {
    static String version = "Version 2.1 (2015-01-28)";
    static int rate = 6;
    static float drop = 1.0E-4f;

    Sclip() {
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            if (args[0].equals("-f")) {
                Sclip.spliter(args[1]);
            } else if (args[0].equals("-a")) {
                Sclip.spliter(args[1], args[2], "a");
            } else if (args[0].equals("-c")) {
                Sclip.spliter(args[1], args[2], "c");
            } else if (args[0].equals("-e")) {
                Sclip.spliter(args[1], args[2], "e");
            } else if (args[0].equals("-o")) {
                Sclip.spliter(args[1], args[2], "o");
            } else if (args[0].equals("-p")) {
                Sclip.spliter(args[1], args[2], "p");
            } else if (args[0].equals("-s")) {
                Sclip.spliter(args[1], args[2], "s");
            } else if (args[0].equals("-v")) {
                System.out.println(version);
            } else if (args.length == 4) {
                Sclip.spliter(args[0], args[1], args[2], args[3]);
            } else {
                Sclip.helpMessage();
                System.exit(0);
            }
        } else {
            Sclip.helpMessage();
            System.exit(0);
        }
    }

    static void helpMessage() {
        System.out.println("sclip(SoundClip): " + version);
        System.out.println("USAGE 1: sclip [input wave file] [star time] [end time] [output file]");
        System.out.println(" The start time and the end time are indicated as a total of seconds \n or the [hh:mm:ss] form.");
        System.out.println("USAGE 2: sclip -f [batch file F]");
        System.out.println(" The batch file F contains a set of records consisting of \n [input file],[start time],[end time],[output file]  in a CSV style, \n or the format of GIST(General Time Information Format for Linguistics)\n defined by Ohya 2015(CILDC4).\n If no output file name, the name is automatically given.");
        System.out.println("USAGE 3: sclip -a [shared input wav file] [batch file A]");
        System.out.println(" The batch file A is a region list in a CSV style, or the format of GIST.\n If no output file name, the name is automatically given.");
        System.out.println("USAGE 4: sclip -c [shared input wav file] [batch file C]");
        System.out.println(" The bach file C contains a set of records, each of which consists of \n [start time] [end time] in this way like a CSV format with a white space \n delimiter. Each output file name is automatically given.");
        System.out.println("USAGE 5: sclip -s [shared input wav file] [batch file S]");
        System.out.println(" The batch file S is a region list made by Sony Sound Forge. This file is \n a CSV file with a white space demilitor. The output file name must be given.");
        System.out.println("USAGE 6: sclip -e [shared input wav file] [batch file E]");
        System.out.println(" The batch file E is a region list made by ELAN, which is usually \n called an eaf file.");
        System.out.println("USAGE 7: sclip -o [shared input wav file] [batch file O]");
        System.out.println(" The batch file O is a region list made by Audacity.");
        System.out.println("USAGE 8: sclip -p [shared input wav file] [batch file P]");
        System.out.println(" The batch file P is an output file from Praat Speech Analyzer. \n Only Labeled reasions are extracted.");
        System.out.println("USAGE 9: sclip -v");
        System.out.println(" It shows the version number.");
        System.out.println("This software is very unfriendly. Sorry.");
    }

    static float converter(String text) {
        float time = 0.0f;
        String[] temp = text.split(":");
        if (temp.length == 1) {
            time = Float.parseFloat(text);
        } else if (temp.length == 2) {
            int min = Integer.parseInt(temp[0]);
            float sec = new BigDecimal(Double.parseDouble(temp[1])).setScale(rate, 4).floatValue();
            if (min > 60 || sec > 60.0f) {
                System.out.println("Time Format Error");
                System.out.println("The formats are [hh:mm:ss], [mm:ss], or the total seconds.");
                System.exit(0);
            }
            time = (float)(min * 60) + sec;
        } else if (temp.length == 3) {
            int hr = Integer.parseInt(temp[0]);
            int min = Integer.parseInt(temp[1]);
            float sec = new BigDecimal(Double.parseDouble(temp[2])).setScale(rate, 4).floatValue();
            if (min > 60 || sec > 60.0f) {
                System.out.println("Time Format Error");
                System.out.println("The formats are [hh:mm:ss], [mm:ss], or the total seconds.");
                System.exit(0);
            }
            time = (float)(hr * 60 * 60 + min * 60) + sec;
        } else {
            System.out.println("The formats are [hh:mm:ss], [mm:ss], or the total seconds.");
            System.exit(0);
        }
        return time;
    }

    static void checkTheDuration(float f) {
        if (f < 0.0f) {
            System.out.println();
            System.out.println("Invalid Time Instruction. Time span is over the input sound data.");
            System.exit(0);
        }
    }

    static void spliter(String fileName) {
        try {
            int i;
            File file = new File(fileName);
            Scanner sc = new Scanner(file);
            ArrayList<GistList> lines = new ArrayList<GistList>();
            while (sc.hasNextLine()) {
                String presentLine = sc.nextLine();
                String[] temp = presentLine.split(",");
                GistList line = new GistList();
                i = 0;
                while (i < temp.length) {
                    if (temp[i].split(":").length > 2) {
                        if (temp[i + 1] != null) {
                            String tmp1 = temp[i];
                            String tmp2 = temp[++i];
                            GistU u = new GistU("time", tmp1, tmp2);
                            line.add(u);
                        } else {
                            System.out.println("invalid format in a batch file");
                            System.out.println(presentLine);
                            System.exit(1);
                        }
                    } else {
                        GistU u = new GistU("name", temp[i]);
                        line.add(u);
                    }
                    ++i;
                }
                lines.add(line);
            }
            int counterForFileName = 0;
            String tempFileName = "";
            AudioFileFormat ff = null;
            i = 0;
            while (i < lines.size()) {
                GistList gl = (GistList)lines.get(i);
                byte[] soundData = null;
                int j = 0;
                while (j < gl.size()) {
                    Sclipter sclp = new Sclipter();
                    if (gl.get((int)j).type == "time") {
                        float start = Sclip.converter(gl.get((int)j).start);
                        float end = Sclip.converter(gl.get((int)j).end);
                        float duration = end - start - drop;
                        Sclip.checkTheDuration(duration);
                        sclp.setup(soundData, ff, start, duration);
                        sclp.mainWork(0);
                        soundData = sclp.getSound();
                        if (j == gl.size() - 1) {
                            String finalOutputFileName = String.valueOf(tempFileName) + "_" + String.format("%03d", counterForFileName) + ".wav";
                            Sclipter.writeSoundData(soundData, ff, finalOutputFileName);
                            ++counterForFileName;
                        }
                    } else if (gl.get((int)j).type == "name") {
                        if (j == 0) {
                            tempFileName = gl.get((int)j).name.replace(".wav", "");
                            ff = AudioSystem.getAudioFileFormat(new File(gl.get((int)j).name));
                            AudioFormat af = ff.getFormat();
                            AudioInputStream inAis = AudioSystem.getAudioInputStream(new File(gl.get((int)j).name));
                            int size = (int)Math.ceil((long)af.getFrameSize() * inAis.getFrameLength());
                            soundData = new byte[size];
                            int bytesNumber = inAis.read(soundData);
                            System.out.println("Source File: " + gl.get((int)j).name);
                            System.out.println("Sample/Frame Rate: " + af.getSampleRate());
                            System.out.println("Frame Size: " + af.getFrameSize());
                            System.out.println("Input Frame Length: " + inAis.getFrameLength());
                            System.out.println("Input File Frame Size:  " + size);
                        } else {
                            Sclipter.writeSoundData(soundData, ff, gl.get((int)j).name);
                        }
                    }
                    ++j;
                }
                System.out.println("----");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Batch File Error(spliterS)");
            System.exit(1);
        }
    }

    static void spliter(String inFileName, String fileName, String op) {
        try {
            File inFile = new File(inFileName);
            File file = new File(fileName);
            AudioFileFormat ff = AudioSystem.getAudioFileFormat(inFile);
            AudioInputStream inAis = AudioSystem.getAudioInputStream(inFile);
            AudioFormat af = ff.getFormat();
            int size = (int)Math.ceil((long)af.getFrameSize() * inAis.getFrameLength());
            byte[] soundData = new byte[size];
            int bytesNumber = inAis.read(soundData);
            System.out.println("Source File: " + inFileName);
            System.out.println("Sample/Frame Rate: " + af.getSampleRate());
            System.out.println("Frame Size: " + af.getFrameSize());
            System.out.println("Input Frame Length: " + inAis.getFrameLength());
            System.out.println("Input File Frame Size:  " + size);
            System.out.println("------------");
            Scanner sc = new Scanner(file);
            if (op.equals("a")) {
                ArrayList<GistList> lines = new ArrayList<GistList>();
                while (sc.hasNextLine()) {
                    String presentLine = sc.nextLine();
                    String[] temp = presentLine.split(",");
                    GistList line = new GistList();
                    int i = 0;
                    while (i < temp.length) {
                        if (temp[i].split(":").length > 2) {
                            if (temp[i + 1] != null) {
                                String tmp1 = temp[i];
                                String tmp2 = temp[++i];
                                GistU u = new GistU("time", tmp1, tmp2);
                                line.add(u);
                            } else {
                                System.out.println("invalid format");
                                System.out.println(presentLine);
                                System.exit(1);
                            }
                        } else {
                            GistU u = new GistU("name", temp[i]);
                            line.add(u);
                        }
                        ++i;
                    }
                    lines.add(line);
                }
                int counterForFileName = 0;
                String tempFileName = inFileName.replace(".wav", "");
                int i = 0;
                while (i < lines.size()) {
                    GistList gl = (GistList)lines.get(i);
                    byte[] tempSoundData = soundData;
                    int j = 0;
                    while (j < gl.size()) {
                        Sclipter sclp = new Sclipter();
                        if (gl.get((int)j).type == "time") {
                            float start = Sclip.converter(gl.get((int)j).start);
                            float end = Sclip.converter(gl.get((int)j).end);
                            float duration = end - start - drop;
                            Sclip.checkTheDuration(duration);
                            sclp.setup(tempSoundData, ff, start, duration);
                            sclp.mainWork(0);
                            tempSoundData = sclp.getSound();
                            if (j == gl.size() - 1) {
                                String finalOutputFileName = String.valueOf(tempFileName) + "_" + String.format("%03d", counterForFileName) + ".wav";
                                Sclipter.writeSoundData(tempSoundData, ff, finalOutputFileName);
                                ++counterForFileName;
                            }
                        } else if (gl.get((int)j).type == "name") {
                            Sclipter.writeSoundData(tempSoundData, ff, gl.get((int)j).name);
                        }
                        ++j;
                    }
                    System.out.println("----");
                    ++i;
                }
            } else if (op.equals("p")) {
                int counter = 0;
                while (sc.hasNext()) {
                    String line = sc.nextLine();
                    if (!line.matches("\\s*?intervals\\s\\[.*")) continue;
                    ++counter;
                    String xmin = sc.nextLine();
                    String xmax = sc.nextLine();
                    String text = sc.nextLine();
                    xmin = xmin.replaceAll("\\s", "");
                    xmax = xmax.replaceAll("\\s", "");
                    text = text.replaceAll("\\s", "");
                    xmin = xmin.replaceAll("xmin=", "");
                    xmax = xmax.replaceAll("xmax=", "");
                    if ((text = text.replaceAll("text=\"(.*)\"", "$1")).isEmpty()) continue;
                    float start = Sclip.converter(xmin);
                    float end = Sclip.converter(xmax);
                    float duration = end - start - drop;
                    Sclip.checkTheDuration(duration);
                    String headInFile = inFileName.replace(".wav", "");
                    String outFileName = "";
                    outFileName = String.valueOf(headInFile) + "." + text + ".wav";
                    System.out.println("Output File: " + outFileName);
                    float fileDuration = (float)inAis.getFrameLength() / af.getSampleRate();
                    Sclip.checkTheDuration(fileDuration - start - duration);
                    Sclipter finalOutputFileName = new Sclipter(soundData, ff, start, duration, outFileName);
                }
                if (counter == 0) {
                    System.out.println("This file may not be made by Praat.");
                    System.exit(1);
                }
            } else if (op.equals("e")) {
                HashMap<String, String> time = new HashMap<String, String>();
                ArrayList<String> unit = new ArrayList<String>();
                String regTime = ".*?TIME_SLOT TIME_SLOT_ID=\"(.*?)\" TIME_VALUE=\"(.*?)\".*";
                Pattern pTime = Pattern.compile(regTime);
                String regUnit = ".*?ALIGNABLE_ANNOTATION ANNOTATION_ID=\"(.*?)\" TIME_SLOT_REF1=\"(.*?)\" TIME_SLOT_REF2=\"(.*?)\".*?";
                Pattern pUnit = Pattern.compile(regUnit);
                while (sc.hasNext()) {
                    String line = sc.nextLine();
                    Matcher mTime = pTime.matcher(line);
                    Matcher mUnit = pUnit.matcher(line);
                    if (mTime.find()) {
                        time.put(mTime.group(1), mTime.group(2));
                    }
                    if (!mUnit.find()) continue;
                    String start = (String)time.get(mUnit.group(2));
                    String end = (String)time.get(mUnit.group(3));
                    if (start == null || end == null) continue;
                    String temp = String.valueOf(start) + "," + end;
                    unit.add(String.valueOf(temp) + "," + mUnit.group(1));
                }
                if (unit.size() == 0) {
                    System.out.println("This file may not be made by ELAN.");
                    System.exit(0);
                }
                int i = 0;
                while (i < unit.size()) {
                    String[] token = new String[3];
                    token = ((String)unit.get(i)).split(",");
                    float start = Sclip.converter(token[0]);
                    float end = Sclip.converter(token[1]);
                    float duration = (end /= 1000.0f) - (start /= 1000.0f) - drop;
                    Sclip.checkTheDuration(duration);
                    String headInFile = inFileName.replace(".wav", "");
                    String outFileName = "";
                    outFileName = String.valueOf(headInFile) + "." + token[2] + ".wav";
                    System.out.println("Output File: " + outFileName);
                    float fileDuration = (float)inAis.getFrameLength() / af.getSampleRate();
                    Sclip.checkTheDuration(fileDuration - start - duration);
                    Sclipter sclipter = new Sclipter(soundData, ff, start, duration, outFileName);
                    ++i;
                }
            } else {
                int counter = 0;
                while (sc.hasNext()) {
                    String temp = sc.nextLine();
                    if (temp.equals("start_region_table") || temp.equals("end_region_table")) continue;
                    ++counter;
                    String[] token = new String[2];
                    if (op.equals("s")) {
                        token = temp.split(" ");
                    } else if (op.equals("c")) {
                        token = temp.split(" ");
                    } else if (op.equals("o")) {
                        token = temp.split("\\t");
                    }
                    if (token.length == 0) {
                        System.out.println("This file may have problems.");
                        System.exit(0);
                    }
                    float start = Sclip.converter(token[0]);
                    float end = Sclip.converter(token[1]);
                    float duration = end - start - drop;
                    Sclip.checkTheDuration(duration);
                    String headInFile = inFileName.replace(".wav", "");
                    String outFileName = "";
                    if (op.equals("a") || op.equals("c")) {
                        String counterName = String.format("%03d", counter);
                        outFileName = String.valueOf(headInFile) + "_" + counterName + ".wav";
                    } else if (op.equals("s") || op.equals("o")) {
                        outFileName = String.valueOf(headInFile) + "_" + token[2] + ".wav";
                    }
                    System.out.println("Output File: " + outFileName);
                    float fileDuration = (float)inAis.getFrameLength() / af.getSampleRate();
                    Sclip.checkTheDuration(fileDuration - start - duration);
                    Sclipter sclipter = new Sclipter(soundData, ff, start, duration, outFileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("File Error(spliterSSS)");
            System.exit(0);
        }
    }

    static void spliter(String inFileName, String startTime, String endTime, String outFileName) {
        try {
            File inFile = new File(inFileName);
            AudioFileFormat ff = AudioSystem.getAudioFileFormat(inFile);
            AudioInputStream inAis = AudioSystem.getAudioInputStream(inFile);
            AudioFormat af = ff.getFormat();
            int size = (int)Math.ceil((long)af.getFrameSize() * inAis.getFrameLength());
            byte[] soundData = new byte[size];
            int bytesNumber = inAis.read(soundData);
            System.out.println("Source File: " + inFileName);
            System.out.println("Sample/Frame Rate: " + af.getSampleRate());
            System.out.println("Frame Size: " + af.getFrameSize());
            System.out.println("Input Frame Length: " + inAis.getFrameLength());
            System.out.println("Input File Frame Size:  " + size);
            System.out.println("------------");
            float start = Sclip.converter(startTime);
            float end = Sclip.converter(endTime);
            float duration = end - start - drop;
            Sclip.checkTheDuration(duration);
            System.out.println("Output File: " + outFileName);
            float fileDuration = (float)inAis.getFrameLength() / af.getSampleRate();
            Sclip.checkTheDuration(fileDuration - start - duration);
            Sclipter sclipter = new Sclipter(soundData, ff, start, duration, outFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("File Error(spliterSSSS for inline version)");
            System.exit(0);
        }
    }
}

